//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace CustomAttributes
{
	[AttributeUsage(AttributeTargets.Class, AllowMultiple=true)]
	class HelloAttribute : Attribute
	{
		private int id;
		private string message;
		public HelloAttribute(string message)
		{
			id = 0;
			this.message = message;
			Console.WriteLine("Tworzenie Hello");
		}
		public int Id
		{
			get
			{
				return id;
			}
			set
			{
				Console.WriteLine("Ustawianie identyfikatora");
				id = value;
			}
		}
		public string Message
		{
			get
			{
				return message;
			}
		}
	}

	[Hello("Witaj wiecie!")]
	[Hello("Witaj wiecie, ponownie!")]
	class MyClass
	{
		public MyClass()
		{
			Console.WriteLine("Tworzenie MyClass");
			Object [] attributes = typeof(MyClass).GetCustomAttributes(true);
			foreach(Attribute attrib in attributes)
			{
				HelloAttribute ha = attrib as HelloAttribute;
				if(ha != null)
				{
					Console.WriteLine("Wiadomo: {0}", ha.Message);
				}
			}
		}
	}

	class CustomAttributesMain
	{
		static void Main(string[] args)
		{
			MyClass m = new MyClass();
		}
	}
}
